/************************************************************************\
	Convert Unicode to "Content-Transfer-Encoding: quoted-printable"
	Uses modified ISO-8859-1 (Latin-1) character encoding
\************************************************************************/

#include "objects.h"
#include "NewtonScript.h"

const char uni0x80To7Bit[] = {
	0x2D, 0x54, 0x7E, 0x7E, 0x3E, 0x53, 0x53, 0x4F, 0x2F, 0x7E, 0x2E, 0x2D, 0x27, 0x59, 0x2F, 0x64,
	0x64, 0x4F, 0x2C, 0x2C, 0x25, 0x2E, 0x5E, 0x22, 0x22, 0x27, 0x27, 0x22, 0x2C, 0x27, 0x31, 0x66,
	0x20, 0x69, 0x63, 0x23, 0x24, 0x59, 0x6F, 0x53, 0x22, 0x43, 0x61, 0x3C, 0x7E, 0x2D, 0x52, 0x2D,
	0x6F, 0x2B, 0x22, 0x22, 0x27, 0x75, 0x50, 0x2D, 0x2C, 0x27, 0x6F, 0x3E, 0x70, 0x50, 0x3C, 0x3F,
	0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x43, 0x45, 0x45, 0x45, 0x45, 0x49, 0x49, 0x49, 0x49,
	0x3C, 0x4E, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x2D, 0x30, 0x55, 0x55, 0x55, 0x55, 0x54, 0x66, 0x42,
	0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x63, 0x65, 0x65, 0x65, 0x65, 0x69, 0x69, 0x69, 0x69,
	0x3E, 0x6E, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x2F, 0x30, 0x75, 0x75, 0x75, 0x75, 0x54, 0x66, 0x79
};

// "oT~~>SSO/~.-'=/ddO,,%.^\"\"'''.'lf ic#$YoS\"Ca<~-R-o+\"\"'uP.,'o>pP<?AAAAAAACEEEEIIII<NOOOOO-0UUUUTfBaaaaaaaceeeeiiii>nooooo/0uuuuTfy";
//ڶ۴ϤШҫռȹ̀܄ͅׯާݖֿ"

const UShort uni2isoTbl[] = {
	 0,   0,   0,   0,    0,   0,   0,   0,   0,   9,   0,   0,   0,  13,   0,   0,
	 0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
//	32,  32,  32,  32,   32,  32,  32,  32,  32,   9,  10,  32,  32,  13,  32,  32,
//	32,  32,  32,  32,   32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
	32,  33,  34,  35,   36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
	48,  49,  50,  51,   52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
	64,  65,  66,  67,   68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
	80,  81,  82,  83,   84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
	96,  97,  98,  99,  100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
	112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,

	0x2022, 0x2122, 0x2260, 0x221E, 0x2265, 0x2211, 0x222B, 0x2126,
	0x221A, 0x2248, 0x2026, 0x2014, 0x2018, 0x0178, 0x2044, 0x2202,
	0x2206, 0x0152, 0x201A, 0x201E, 0x2030, 0xF714, 0x02C6, 0x02DC,
	0x02D8, 0x02D9, 0x02DA, 0x02DD, 0x02DB, 0x02C7, 0x0131, 0x0192,
	0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x0153, 0x00A7,
	0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x2013, 0x00AE, 0x00AF,
	0x00B0, 0x00B1, 0x201D, 0x201C, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
	0x00B8, 0x2019, 0x00BA, 0x00BB, 0x03C0, 0x220F, 0x2264, 0x00BF,
	0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
	0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
	0x2039, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x25CA,
	0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x2020, 0xFB01, 0x00DF,
	0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
	0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
	0x203A, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
	0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x2021, 0xFB02, 0x00FF
};

static void	_WrapTxQuoted ( UShort *src, char *dest, long maxW, RefArg txFunc );
static void	_WrapTxASCII ( UShort *src, char *dest, long maxW, RefArg txFunc );
static void	_finishLine ( char *buff, long ix, char doQuote, RefArg txFunc );
static long	_UnquoteInPlace  ( UShort *unicodeP );

long	_stuffQPChar ( char *buff, long offset, UShort uniChar );
void	_stuffQHex ( char *buff, long ix, UByte hexV );
long	_stuff7BitEquiv ( char *buff, long offset, UShort uniChar );
char	_char2nybble ( char n );


extern "C" Ref WrapTxText ( RefArg rcvr, RefArg srcUnicode, RefArg destBinObj, RefArg maxW, RefArg txFunc, RefArg doQuotedP )
{
	if ( !IsString(srcUnicode) )
		ThrowBadTypeWithFrameData ( -48402, srcUnicode );	// expected a string

	if ( !IsBinary(destBinObj) )
		ThrowBadTypeWithFrameData ( -48408, destBinObj );	// expected a binary object

	if ( !IsInt(maxW) )
		ThrowBadTypeWithFrameData ( -48406, maxW );			// expected an integer

	if ( !IsFunction(txFunc) )
		ThrowBadTypeWithFrameData ( -48411, txFunc );		// expected a function

	long	maxWidth = RefToInt ( maxW );

	WITH_LOCKED_BINARY ( srcUnicode, srcP )
	WITH_LOCKED_BINARY ( destBinObj, destP )

	if ( doQuotedP == NILREF )
		_WrapTxASCII  ( (UShort *)srcP, (char *)destP, maxWidth, txFunc );
	else
		_WrapTxQuoted ( (UShort *)srcP, (char *)destP, maxWidth, txFunc );

	END_WITH_LOCKED_BINARY ( srcUnicode )
	END_WITH_LOCKED_BINARY ( destBinObj )

	return NILREF;
}


//	newSLen := call kUnquoteInPlaceFunc with ( txt );
//	StrMunger ( txt, newSLen, nil,  nil, 0, nil );

extern "C" Ref UnquoteInPlace ( RefArg rcvr, RefArg srcUnicode )
{
	if ( !IsString(srcUnicode) )
		ThrowBadTypeWithFrameData ( -48402, srcUnicode );	// expected a string

	if ( IsReadOnly(srcUnicode) )
		ThrowBadTypeWithFrameData ( -48214, srcUnicode );	// object is Read-Only

	long	newSLen;

	WITH_LOCKED_BINARY ( srcUnicode, unicodeP )

	newSLen = _UnquoteInPlace  ( (UShort *)unicodeP );

	END_WITH_LOCKED_BINARY ( srcUnicode )

	return MakeInt ( newSLen );
}


static void _WrapTxQuoted ( UShort *src, char *dest, long maxW, RefArg txFunc )
{
	//char	outBuff[256];
	char	*outBuff = dest;
	long	i = 0;
	long	k = 0;
	UShort	ch;
	long	prevSrcSpc = 0;
	long	prevDstSpc = 0;

	while ( ch = src[i] )
	{
		// quote first "." character on a line
		if ( k == 0 && ch == 0x2E )
		{
			k = _stuffQPChar ( outBuff, k, ch );
			i++;
		}
		else
		{
			if ( k > (maxW-2) && ch != 0x0D )
			{
				// split right here if no spaces in this line
				if ( prevDstSpc < maxW / 4 )
				{
					_finishLine ( outBuff, k, true, txFunc );
				}
				else
				{
					_finishLine ( outBuff, prevDstSpc + 1, true, txFunc );

					i = prevSrcSpc + 1;
				}
				prevSrcSpc = i;
				prevDstSpc = 0;
				k = 0;
			}
			else
			{
				// keep track of <SPC> char positions
				if ( ch == 0x20 )
				{
					prevSrcSpc = i;
					prevDstSpc = k;
				}

				// do characters which have to be quoted
				if ( ch == '=' || ch > 0x7E )
				{
					k = _stuffQPChar ( outBuff, k, ch );
					i++;
				}

				// if we're at a <CR> finish the line and reset "k"
				else if ( ch == 0x0D )
				{
					//if ( outBuff [ k-1 ] == 0x20 )
					//	outBuff [ k++ ] = '=';
					_finishLine ( outBuff, k, nil, txFunc );
					i++;
					prevSrcSpc = i;
					prevDstSpc = 0;
					k = 0;
				}

				// just stuff in normal characters
				else
				{
					outBuff [ k++ ] = ch;
					i++;
				}
			}
		}
	}
	if ( k > 0 )
		_finishLine ( outBuff, k, nil, txFunc );
}


static void _finishLine ( char *buff, long ix, char doQuote, RefArg txFunc )
{
	if ( doQuote )
		buff [ ix++ ] = '=';

	buff [ ix++ ] = 0x0D;
	buff [ ix   ] = 0x0A;

	buff [ ix+1 ] = 0x00;

	NSCall ( txFunc, MakeString ( buff ) );
}


long _stuffQPChar ( char *buff, long offset, UShort uniChar )
{
	if ( uniChar < 0x80 )
	{
		_stuffQHex ( buff, offset, uniChar & 0xFF );
		return offset + 3;
	}
	else
	{
		long	n;
		for ( n = 0x80; n < 256; n++ )
		{
			if ( uni2isoTbl[n] == uniChar )
			{
				_stuffQHex ( buff, offset, n & 0xFF );
				return offset + 3;
			}
		}
	}
	return offset;
}


void _stuffQHex ( char *buff, long ix, UByte hexV )
{
	char *hexS = "0123456789ABCDEF";

	buff [ ix++ ] = '=';
	char	c = hexS [ (hexV >> 4) & 0x0F ];
	buff [ ix++ ] = c;
	c = hexS [ hexV & 0x0F ];
	buff [ ix ] = c;
}


static void _WrapTxASCII ( UShort *src, char *dest, long maxW, RefArg txFunc )
{
	char	*outBuff = dest;
	long	i = 0;
	long	k = 0;
	UShort	ch;
	long	prevSrcSpc = 0;
	long	prevDstSpc = 0;

	while ( ch = src[i] )
	{
		// convert solitary first "." character on a line
		// to double ".."
		if ( k == 0 && ch == 0x2E && !(src[i] == 0x2E) )
		{
			outBuff[k++] = 0x2E;
			outBuff[k++] = 0x2E;
			i++;
		}
		else
		{
			if ( k > (maxW-1) && ch != 0x0D )
			{
				// split right here if no spaces in this line
				if ( prevDstSpc < maxW / 4 )
				{
					_finishLine ( outBuff, k, nil, txFunc );
				}
				else
				{
					_finishLine ( outBuff, prevDstSpc, nil, txFunc );

					i = prevSrcSpc + 1;		// point 1 beyond the space <7-bit>
				}
				prevSrcSpc = i;
				prevDstSpc = 0;
				k = 0;
			}
			else
			{
				// keep track of <SPC> char positions
				if ( ch == 0x20 )
				{
					prevSrcSpc = i;
					prevDstSpc = k;
				}

				// do characters which have to be quoted
				if ( ch > 0x7E )
				{
					k = _stuff7BitEquiv ( outBuff, k, ch );
					i++;
				}

				// if we're at a <CR> finish the line and reset "k"
				else if ( ch == 0x0D )
				{
					_finishLine ( outBuff, k, nil, txFunc );
					i++;
					prevSrcSpc = i;
					prevDstSpc = 0;
					k = 0;
				}

				// just stuff in normal characters
				else
				{
					outBuff [ k++ ] = ch;
					i++;
				}
			}
		}
	}
	if ( k > 0 )
		_finishLine ( outBuff, k, nil, txFunc );
}


long _stuff7BitEquiv ( char *buff, long offset, UShort uniChar )
{
	if ( uniChar < 0x80 )
	{
		buff[offset] = 0xFF & uniChar;
		return offset + 1;
	}
	else
	{
		long	n;
		for ( n = 0x80; n < 256; n++ )
		{
			if ( uni2isoTbl[n] == uniChar )
			{
				buff[offset] = uni0x80To7Bit [ n - 0x80 ];
				return offset + 1;
			}
		}
	}
	return offset;
}


long _char2nybble ( UShort n )
{
	long v = n - 0x30;
	if ( v < 0 )
		return 0;

	if ( v < 10 )
		return v;
	else
		v = v - 7;

	if ( v < 16 )
		return v;
	else
		v = v - 32;

	if ( v > 9 && v < 16 )
		return v;

	return 0;
}


static long _UnquoteInPlace  ( UShort *unicodeP )
{
	UShort	*srcP  = unicodeP;
	UShort	*destP = unicodeP;
	ULong	destIx = 0;

	UShort	ch;
	while ( (ch = *srcP++) )
	{
		if ( ch == 0x3D )
		{
			// skip over escaped <CR>
			if ( *srcP == 0x0D )
			{
				srcP++;
			}
			// most likely a pair of HEX chars
			else
			{
				UShort	c1 = 0;
				if ( *srcP )
					c1 = *srcP++;

				UShort	c2 = 0;
				if ( *srcP )
					c2 = *srcP++;

				long	xIx = ( _char2nybble(c1) << 4 ) | _char2nybble(c2);

				if ( (ch = uni2isoTbl [ xIx ]) )
					destP [ destIx++ ] = ch;
			}
		}
		else
		{
			destP [ destIx++ ] = ch;
		}
	}
	return destIx;
}
